#include <iostream>
using namespace std;

#define modulus modulus190

const int modulus = 1e9 + 7;

int BinaryPow(int x, int pw)
{
    if (pw == 0) {
        return 1;
    }
    if ((pw & 1) == 1) {
        return (1LL * x * BinaryPow(x, pw - 1)) % modulus;
    }
    return BinaryPow((1LL * x * x) % modulus, pw >> 1);
}

int GetInv(long long x)
{
    return BinaryPow(x % modulus, modulus - 2);
}

const int kMaxN = 2e3;

int dp[kMaxN + 1][kMaxN + 1];

int GetDp(int L, int R, int K)
{
    int result = dp[R][K];
    if (L > 0) {
        result -= dp[L - 1][K];
        if (result < 0) {
            result += modulus;
        }
    }
    return result;
}

int GetDp(int N, int K)
{
    return GetDp(N, N, K);
}

int N, X;
long long D;

void CalcDp()
{
    for (int n = 0; n <= N; ++n) {
        dp[n][0] = 1;
    }

    for (int k = 1; k <= N; ++k) {
        for (int n = 0; n < k; ++n) {
            dp[n][k] = 0;
        }
        for (int n = k; n <= N; ++n) {
            dp[n][k] = dp[n - 1][k];

            int left = max(0, n - X + 1);
            int right = n - 1;

            dp[n][k] += GetDp(left, right, k - 1);

            if (dp[n][k] >= modulus) {
                dp[n][k] -= modulus;
            }
        }
    }
}

int main()
{
    ios_base::sync_with_stdio(false);

    while (true) {
        cin >> N >> D >> X;

        if (N == 0 && D == 0 && X == 0) {
            break;
        }


        if (X == 1) {
            cout << 0 << endl;
            continue;
        }

        CalcDp();

        int result = 0;

        int up = 1;
        int down = 1;
        for (int K = 1; K <= min(D, (long long) N); ++K) {
            up = (1LL * up * ((D - K + 1) % modulus)) % modulus;
            down = (1LL * down * K) % modulus;

            int temp = (1LL * up * GetInv(down)) % modulus;

            result = result + (1LL * temp * GetDp(N, K)) % modulus;

            if (result >= modulus) {
                result -= modulus;
            }
        }

        cout << result << endl;
    }

    return 0;
}
